function [symbols_OUT] = ...
    tx_modulation(bits_IN, modulation_TYPE, QAM_TYPE, Eb)
% Maps the bits to symbols. Make sure the bits are zero-padded before using
% this function.
% 1-QAM
% 2-PSK
% 3-FSK (be aware, this cannot be used with OFDM)

    % QAM modulation 
    if modulation_TYPE == 1;

            if QAM_TYPE == 4 || QAM_TYPE == 16 || QAM_TYPE == 64;
                
                 symbols_OUT = QAM_modulation(bits_IN, QAM_TYPE, Eb);
                 
            else 
                disp('Input not valid\n')

            end
            
    % 8-PSK modulation
    elseif modulation_TYPE == 2;
        
        symbols_OUT = Eight_PSK_Modulation(bits_IN,Eb);
        
    % 8-FSK    
    elseif modulation_TYPE == 3;
        
        symbols_OUT = FSK_Modulation(bits_IN);
        
    end
    
end